function [oIsMemberRows,oLocate] = CellStrIsMemberRows( ...
    iCellStrA,iCellStrB)
pErrId = ['Matlab:',mfilename];
pColumnNumber = size(iCellStrA,2);
if (pColumnNumber < 2) || (pColumnNumber ~= size(iCellStrB,2))
    error(pErrId,['"iCellStrA" and "iCellStrB" should have the ' ...
        'same number of columns, and should be greater than 1.']);
end
pUniqueItems = unique([iCellStrA(:);iCellStrB(:)]);
[~,iCellStrAItemsLoc] = ismember(iCellStrA,pUniqueItems);
[~,iCellStrBItemsLoc] = ismember(iCellStrB,pUniqueItems);
[oIsMemberRows,oLocate] = ismember(iCellStrAItemsLoc, ...
    iCellStrBItemsLoc,'rows');

end
