function oAnceStruct = GOTermAncestors(iGOStruct)
error(nargchk(1,1,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if ~isstruct(iGOStruct) || ~all(ismember( ...
        {'ParseData';'Relation_IsA'}, fieldnames(iGOStruct)))
    error(pErrId,'iGOStruct should be a Gene Ontology structure.');
end
oAnceStruct.GOTermsId = iGOStruct.ParseData(:,1);
pGOTermsLength = length(oAnceStruct.GOTermsId);
oAnceStruct.GOTermsDepth = zeros(pGOTermsLength,1,'uint8');
oAnceStruct.GOTermsNameSpace = zeros(pGOTermsLength,1,'uint8');
pRootOntology = {'GO:0008150';'GO:0005575';'GO:0003674'};
oAnceStruct.RootNameSpace = {'biological_process'; ...
    'cellular_component';'molecular_function'};
pGOTermLength = size(oAnceStruct.GOTermsId,1);
if pGOTermLength ~= size(unique(oAnceStruct.GOTermsId),1)
    error(pErrorMsgId,['"iGOStruct.ParseData(:,1)" should not' ...
        ' contain repeated GO term identifier.']);
end
[ptTermCk,ptTermLoc] = ismember(oAnceStruct.GOTermsId,pRootOntology);
if sum(ptTermCk) ~= 3
    error(pErrId,['Exclusive three root ontology identifiers should ' ...
        'be found in "iGOStruct.ParseData(:,1)".']);
end
oAnceStruct.GOTermsNameSpace(ptTermCk) = ptTermLoc(ptTermCk);
pTermNotInRoot = find(~ptTermCk)';
[~,pRootLocInTerm] = ismember(pRootOntology,oAnceStruct.GOTermsId);
pGOMatrix = GetInteractMatrix(iGOStruct.Relation_IsA, ...
    oAnceStruct.GOTermsId,true);
if pGOTermLength < 2^8
    fDataType = @uint8;
elseif pGOTermLength < 2^16
    fDataType = @uint16;
elseif pGOTermLength < 2^32
    fDataType = @uint32;
elseif pGOTermLength < 2^64
    fDataType = @uint64;
else
    error(pErrId,'Out of memory.');
end
oAnceStruct.AncestorLoc = cell(pGOTermsLength,1);
for pI1 = 1:pGOTermsLength
    [pAnceTerms,oAnceStruct.GOTermsDepth(pI1)] = f_GOAnceSearch(pI1,0);
    oAnceStruct.AncestorLoc{pI1} = fDataType(find(pAnceTerms)');
end
for pI1 = pTermNotInRoot
    [ptCkInRoot,ptLocInRoot] = ismember( ...
        oAnceStruct.AncestorLoc{pI1},pRootLocInTerm);
    if nnz(ptCkInRoot) == 1
        oAnceStruct.GOTermsNameSpace(pI1) = ptLocInRoot(ptCkInRoot);
    else
        oAnceStruct.GOTermsDepth(pI1) = 0;
        display(['Notifying: Multiple root ontology identifiers are ' ...
            'found in oAnceStruct.GOTermsId(',num2str(pI1),').']);
    end
end

function [o_AnceTerms,o_SearchHeight] = f_GOAnceSearch( ...
        i_GOTerms,i_SearchHeight)
    o_AnceTerms = any(pGOMatrix.InterMatrix(i_GOTerms,:),1);
    if any(o_AnceTerms)
        [p_UpperAnceTerms,o_SearchHeight] = f_GOAnceSearch( ...
            o_AnceTerms,(i_SearchHeight + 1));
        if any(p_UpperAnceTerms)
            o_AnceTerms = or(o_AnceTerms,p_UpperAnceTerms);
        end
    else
        o_SearchHeight = i_SearchHeight;
    end
end

end
