function [oAttribute1,oAttribute2,oAttribute3] = GetConnectAttribute( ...
    iConnect1,iNeighbors1,iConnect2,iNeighbors2,iConnect3,iNeighbors3)
error(nargchk(2,6,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if any(eq(nargin,[3,5]))
    error(pErrId,'Input parameter number should be 2, 4, or 6.');
end
if eq(nargin,2)
    if nargout ~= 1
        error(pErrId,'Output parameter number should be 1.');
    end
    iConnect2 = iConnect1;
    iNeighbors2 = iNeighbors1;
end
if eq(nargin,4) && nargout ~= 2
    error(pErrId,'Output parameter number should be 2.');
end
if eq(nargin,6) && nargout ~= 3
    error(pErrId,'Output parameter number should be 3.');
end
if ~iscolumn(iConnect1)
    error(pErrId,'iConnect1 should be an m-by-1 column vector.');
end
if ~iscolumn(iConnect2)
    error(pErrId,'iConnect2 should be an m-by-1 column vector.');
end
if ~isstruct(iNeighbors1)
    error(pErrId,'iNeighbors1 should be a struct of interact neighbors.');
end
if ~isstruct(iNeighbors2)
    error(pErrId,'iNeighbors2 should be a struct of interact neighbors.');
end
pFieldNames = {'InterItemDegree', 'ItemsIsIdentical', ...
    'ItemsDirectInteract', 'ItemsShortDistance', ...
    'InterBetweenness', 'CommonNeighbor_1stOrder', ...
    'CommonNeighbor_2ndOrder', 'CommonNeighbor_3rdOrder', ...
    'TopologyOverlap_1stOrder', 'TopologyOverlap_2ndOrder', ...
    'TopologyOverlap_3rdOrder', 'ClusterCoeff_1stOrder', ...
    'ClusterCoeff_2ndOrder', 'ClusterCoeff_3rdOrder', ...
    'InterASimi_1stOrder', 'InterBSimi_1stOrder', 'IntraSimi_1stOrder', ...
    'InterASimi_2ndOrder', 'InterBSimi_2ndOrder', 'IntraSimi_2ndOrder', ...
    'InterASimi_3rdOrder', 'InterBSimi_3rdOrder', 'IntraSimi_3rdOrder'};
if ~all(ismember(pFieldNames,fieldnames(iNeighbors1)))
    error(pErrId,['iNeighbors1 should be a struct generated '...
        'by GetInteractNeighbor.']);
end
if ~all(ismember(pFieldNames,fieldnames(iNeighbors2)))
    error(pErrId,['iNeighbors2 should be a struct generated ' ...
        'by GetInteractNeighbor.']);
end
if eq(nargin,6)
    if ~iscolumn(iConnect3)
        error(pErrId,'iConnect3 should be an m-by-1 column vector.');
    end
    if ~isstruct(iNeighbors3)
        error(pErrId,'iNeighbors3 should be a struct of interact neighbors.');
    end
    if ~all(ismember(pFieldNames,fieldnames(iNeighbors3)))
        error(pErrId,['iNeighbors3 should be a struct generated ' ...
            'by GetInteractNeighbor.']);
    end
end
pSumNeib1ItemDegree = sum(iNeighbors1.InterItemDegree,2);
pSumNeib2ItemDegree = sum(iNeighbors2.InterItemDegree,2);
pMaxItemDegree = max([pSumNeib1ItemDegree;pSumNeib2ItemDegree]);
iNeighbors1.InterItemDegree = (pSumNeib1ItemDegree/pMaxItemDegree).^(1/5);
iNeighbors2.InterItemDegree = (pSumNeib2ItemDegree/pMaxItemDegree).^(1/5);
iNeighbors1.ItemsIsIdentical = double(iNeighbors1.ItemsIsIdentical);
iNeighbors2.ItemsIsIdentical = double(iNeighbors2.ItemsIsIdentical);
pMaxShortDist = double(max([iNeighbors1.ItemsShortDistance; ...
    iNeighbors2.ItemsShortDistance]));
iNeighbors1.ItemsShortDistance = double( ...
    iNeighbors1.ItemsShortDistance)/pMaxShortDist;
iNeighbors2.ItemsShortDistance = double( ...
    iNeighbors2.ItemsShortDistance)/pMaxShortDist;
pMaxIntBetw = max([iNeighbors1.InterBetweenness; ...
    iNeighbors2.InterBetweenness]);
iNeighbors1.InterBetweenness =  ...
    (iNeighbors1.InterBetweenness/pMaxIntBetw) .^ (1/5);
iNeighbors2.InterBetweenness = ...
    (iNeighbors2.InterBetweenness/pMaxIntBetw) .^ (1/5);
pMaxCN1st = max([iNeighbors1.CommonNeighbor_1stOrder; ...
    iNeighbors2.CommonNeighbor_1stOrder]);
iNeighbors1.CommonNeighbor_1stOrder =  ...
    (iNeighbors1.CommonNeighbor_1stOrder/pMaxCN1st) .^ (1/5);
iNeighbors2.CommonNeighbor_1stOrder =  ...
    (iNeighbors2.CommonNeighbor_1stOrder/pMaxCN1st) .^ (1/5);
pMaxCN2nd = max([iNeighbors1.CommonNeighbor_2ndOrder; ...
    iNeighbors2.CommonNeighbor_2ndOrder]);
iNeighbors1.CommonNeighbor_2ndOrder =  ...
    (iNeighbors1.CommonNeighbor_2ndOrder/pMaxCN2nd) .^ (1/5);
iNeighbors2.CommonNeighbor_2ndOrder =  ...
    (iNeighbors2.CommonNeighbor_2ndOrder/pMaxCN2nd) .^ (1/5);
pMaxCN3rd = max([iNeighbors1.CommonNeighbor_3rdOrder; ...
    iNeighbors2.CommonNeighbor_3rdOrder]);
iNeighbors1.CommonNeighbor_3rdOrder =  ...
    (iNeighbors1.CommonNeighbor_3rdOrder/pMaxCN3rd) .^ (1/5);
iNeighbors2.CommonNeighbor_3rdOrder =  ...
    (iNeighbors2.CommonNeighbor_3rdOrder/pMaxCN3rd) .^ (1/5);
oAttribute1 = f_ConnectAttribute(iConnect1,iNeighbors1);
if any(eq(nargin,[4,6]))
    oAttribute2 = f_ConnectAttribute(iConnect2,iNeighbors2);
end
if eq(nargin,6)
    pSumNeib3ItemDegree = sum(iNeighbors3.InterItemDegree,2);
    iNeighbors3.InterItemDegree = (pSumNeib3ItemDegree/pMaxItemDegree).^(1/5);
    iNeighbors3.ItemsIsIdentical = double(iNeighbors3.ItemsIsIdentical);
    iNeighbors3.ItemsShortDistance = double( ...
        iNeighbors3.ItemsShortDistance)/pMaxShortDist;
    iNeighbors3.InterBetweenness =  ...
        (iNeighbors3.InterBetweenness/pMaxIntBetw) .^ (1/5);
    iNeighbors3.CommonNeighbor_1stOrder =  ...
        (iNeighbors3.CommonNeighbor_1stOrder/pMaxCN1st) .^ (1/5);
    iNeighbors3.CommonNeighbor_2ndOrder =  ...
        (iNeighbors3.CommonNeighbor_2ndOrder/pMaxCN2nd) .^ (1/5);
    iNeighbors3.CommonNeighbor_3rdOrder =  ...
        (iNeighbors3.CommonNeighbor_3rdOrder/pMaxCN3rd) .^ (1/5);
    oAttribute3 = f_ConnectAttribute(iConnect3,iNeighbors3);
end

function o_Attribute = f_ConnectAttribute(i_Connect,i_Neighbors)
    p_NeibFieldName = fieldnames(i_Neighbors);
    [p_NeibRowNo,p_NeibColNo] = cellfun(@(x)size(i_Neighbors.(x)), ...
        p_NeibFieldName,'UniformOutput',false);
    p_NeibRowNo = cell2mat(p_NeibRowNo);
    p_NeibColNo = cell2mat(p_NeibColNo);
    p_Idx = [0;cumsum(p_NeibColNo)];
    p_Block = sum(p_NeibColNo);
    if eq(length(unique(p_NeibRowNo)),1)
        p_NeibRowNo = p_NeibRowNo(1);
    else
        error(pErrId,['Data matrix of each field of iNeighbors1/2/3 ' ...
            'should have the same record (i.e. row) number.']);
    end
    p_ConnCk = and(~cellfun('isempty',i_Connect), cell2mat( ...
        cellfun(@(x)all(reshape(and(gt(x,0),le(x,p_NeibRowNo)),1,[])), ...
        i_Connect,'UniformOutput',false)));
    if ~all(p_ConnCk)
        error(pErrId,['Some elements of iConnect1/2/3 cannot be ' ...
            'found in iNeighbors1/2/3.']);
    end
    o_Attribute = zeros(size(i_Connect,1),p_Block*3);
    for p_I1 = 1:size(p_NeibFieldName,1)
        for p_I2 = 1:p_NeibColNo(p_I1)
            p_NeibData = i_Neighbors.(p_NeibFieldName{p_I1})(:,p_I2);
            p_ConnData = cellfun(@(x)p_NeibData(x),i_Connect, ...
                'UniformOutput',false);
            o_Attribute(:,p_Idx(p_I1)+p_I2) = cell2mat(cellfun( ...
                @(x)max(x(:)),p_ConnData,'UniformOutput',false));
            o_Attribute(:,p_Idx(p_I1)+p_I2+p_Block) = cell2mat(cellfun( ...
                @(x)mean(x(:)),p_ConnData,'UniformOutput',false));
            o_Attribute(:,p_Idx(p_I1)+p_I2+p_Block*2) = cell2mat(cellfun( ...
                @(x)mean( [max(x,[],1),max(x,[],2)'] ), ...
                p_ConnData,'UniformOutput',false));
        end
    end
end

end
