function [oInteract,oLocInInter] = GetConnectInteract(iConnect)
error(nargchk(1,1,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if ~iscell(iConnect) || size(iConnect,2) ~= 2
    error(pErrId,'iConnect should be an m-by-2 cell array.');
end
pCLength = size(iConnect,1);
pCISize = cellfun('size',iConnect,1);
pCkNE = ~any(cellfun('isempty',iConnect),2);
pICP = cell(pCLength,1);
pICPLoc = cell(pCLength,1);
[pICP(pCkNE),pICPLoc(pCkNE)] = cellfun(@(x,y)GetItemsCrossPair(x,y), ...
    iConnect(pCkNE,1),iConnect(pCkNE,2),'UniformOutput',false);
[pCat,~,pICPLocInCat] = CellArrayDataCat(pICP);
[oInteract,pCatLocInOInt] = GetInteractUnique(pCat);
pICPLocInOInt = cell(pCLength,1);
pICPLocInOInt(pCkNE) = cellfun(@(x)pCatLocInOInt(x), ...
    pICPLocInCat(pCkNE),'UniformOutput',false);
oLocInInter = cell(pCLength,1);
oLocInInter(pCkNE) = arrayfun(@(x,y)zeros(x,y),pCISize(pCkNE,1), ...
    pCISize(pCkNE,2),'UniformOutput',false);
for pI1 = find(pCkNE)'
    oLocInInter{pI1}(sub2ind([pCISize(pI1,1),pCISize(pI1,2)], ...
        pICPLoc{pI1}(:,1),pICPLoc{pI1}(:,2))) = pICPLocInOInt{pI1};
end
end
