function iIntMatStruct = GetIntMatShortPath(iIntMatStruct)
error(nargchk(1,1,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if ~isstruct(iIntMatStruct) || ~all(ismember( ...
        {'InterItems';'InterMatrix'},fieldnames(iIntMatStruct)))
    error(pErrId,'iIntMatStruct should be a InteractMatrix structure.');
end
pIMSize = size(iIntMatStruct.InterMatrix,1);
if pIMSize ~= size(iIntMatStruct.InterMatrix,2)
    error(pErrId,'iIntMatStruct.InterMatrix should be an m-by-m matrix.');
end
if pIMSize ~= size(iIntMatStruct.InterItems,1)
    error(pErrId,'iIntMatStruct.InterItems should be an m-by-1 vector.');
end
iIntMatStruct.ShortestPath = zeros(pIMSize,pIMSize,'uint8');
iIntMatStruct.ShortestPath(sub2ind([pIMSize,pIMSize], ...
    1:pIMSize,1:pIMSize)) = 1;
for pI1 = 1:pIMSize-1
    pI1N = pI1 + 1;
    pShortPath = GetIntMatShortPathP(pI1N:pIMSize,pI1, ...
        iIntMatStruct.InterMatrix,pIMSize);
    iIntMatStruct.ShortestPath(pI1,pI1N:end) = pShortPath;
    iIntMatStruct.ShortestPath(pI1N:end,pI1) = pShortPath';
end
end

function oShortPath = GetIntMatShortPathP(iSearchLoc,iConnectLoc, ...
    iInterMatrix,iIntMatLength)
pSLLength = length(iSearchLoc);
oShortPath = zeros(1,pSLLength,'uint8');
for p_I1 = 1:pSLLength
    pNodeNotSearch = true(iIntMatLength,1);
    oShortPath(p_I1) = f_ShortestPath(iSearchLoc(p_I1),0);
end
function o_ShortPathLength = f_ShortestPath(i_Items,i_Layer)
    i_Layer = i_Layer + 1;
    pNodeNotSearch(i_Items) = false;
    p_DeepItems = and(any(iInterMatrix(:,i_Items),2),pNodeNotSearch);
    if any(p_DeepItems)
        if any(p_DeepItems(iConnectLoc))
            o_ShortPathLength = i_Layer;
        else
            o_ShortPathLength = f_ShortestPath( ...
                find(p_DeepItems),i_Layer);
        end
    else
        o_ShortPathLength = 0;
    end
end

end
