function [oBetweenness,oShortPathTravel] = GetInteractBetween( ...
    iIntMatStruct,iInterItems,iCheckTwice)
error(nargchk(1,3,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if nargin < 3 || isempty(iCheckTwice)
    iCheckTwice = false;
end
if nargin < 2 || isempty(iInterItems)
    iInterItems = iIntMatStruct.InterItems;
end

pIISize = size(iInterItems,2);
if pIISize == 1
    if iCheckTwice
        pType = 3; % For node betweenness with path travel checking.
    else
        pType = 1; % For node betweenness.
    end
elseif pIISize == 2
    if iCheckTwice
        pType = 4; % For edge betweenness with path travel checking.
    else
        pType = 2; % For edge betweenness.
    end
else
    error(pErrId,'iInterItems should be an m-by-1 or m-by-2 matrix.');
end
[pIMSize,ptIMSize] = size(iIntMatStruct.ShortestPath);
if pIMSize ~= ptIMSize
    error(pErrId,'iIntMatStruct.ShortestPath should be an m-by-m matrix.');
end
if iCheckTwice
    if any(pIMSize ~= size(iIntMatStruct.InterMatrix))
        error(pErrId,['iIntMatStruct.InterMatrix should be an m-by-m ' ...
            'matrix with the same size as iIntMatStruct.ShortestPath.']);
    end
    if ~isstruct(iIntMatStruct) || ~all(ismember({'InterItems'; ...
            'InterMatrix';'ShortestPath'},fieldnames(iIntMatStruct)))
        error(pErrId,'iIntMatStruct should be an InteractMatrix struct.');
    end
    if nargout ~= 2
        error(pErrId,['If iCheckTwice is set to true, there should ' ...
            'be two output arguments.']);
    end
else
    if ~isstruct(iIntMatStruct) || ~all(ismember({'InterItems'; ...
            'ShortestPath'},fieldnames(iIntMatStruct)))
        error(pErrId,'iIntMatStruct should be an InteractMatrix struct.');
    end
end

iIntMatStruct.ShortestPath(sub2ind( ...
    [pIMSize,pIMSize],1:pIMSize,1:pIMSize)) = 0;
if pIMSize < 2^16
    fDataConvert = @uint16;
elseif pIMSize < 2^32
    fDataConvert = @uint32;
elseif pIMSize < 2^64
    fDataConvert = @uint64;
else
    error(pErrId,'Out of memory.');
end
[pIntItemCk,pIntItemLoc] = ismember(iInterItems,iIntMatStruct.InterItems);
if any(eq(pType,[1,3]))
    pIntItemLoc = pIntItemLoc(pIntItemCk,:);
else
    pIntItemCk = all(pIntItemCk,2);
    pCkItemEq = eq(pIntItemLoc(:,1),pIntItemLoc(:,2));
    pIntItemCk(pCkItemEq) = false;
    pIntItemLoc = pIntItemLoc(pIntItemCk,:);
end
pOutData = zeros(size(iInterItems,1),1);

pIILength = size(pIntItemLoc,1);
pBetweenness = zeros(pIILength,1);
pShortPathTravel = zeros(pIILength,1);
if pType == 1
    for pI1 = 1:pIILength
        try
            pBetweenness(pI1) = GetInteractBetweenP(fDataConvert, ...
                iIntMatStruct.ShortestPath,pIntItemLoc(pI1));
        catch
            display(['Notifying: Error occurs for iInterItems(', ...
                num2str(pI1),'), possibly out of memory.']);
        end
    end
    oBetweenness = pOutData;
    oBetweenness(pIntItemCk) = pBetweenness;
elseif pType == 2
    for pI1 = 1:pIILength
        try
            pBetweenness(pI1) = GetInteractBetweenP( ...
                fDataConvert,iIntMatStruct.ShortestPath, ...
                pIntItemLoc(pI1,1),pIntItemLoc(pI1,2));
        catch
            display(['Notifying: Error occurs for iInterItems(', ...
                num2str(pI1),',:), possibly out of memory.']);
        end
    end
    oBetweenness = pOutData;
    oBetweenness(pIntItemCk) = pBetweenness;
elseif pType == 3
    for pI1 = 1:pIILength
        try
            [pBetweenness(pI1),pShortPathTravel(pI1)] = ...
                GetInteractBetweenP(fDataConvert, ...
                iIntMatStruct.ShortestPath,pIntItemLoc(pI1), ...
                [],iIntMatStruct.InterMatrix);
        catch
            display(['Notifying: Error occurs for iInterItems(', ...
                num2str(pI1),'), possibly out of memory.']);
        end
    end
    oBetweenness = pOutData;
    oBetweenness(pIntItemCk) = pBetweenness;
    oShortPathTravel = pOutData;
    oShortPathTravel(pIntItemCk) = pShortPathTravel;
elseif pType == 4
    for pI1 = 1:pIILength
        try
            [pBetweenness(pI1),pShortPathTravel(pI1)] = ...
                GetInteractBetweenP(fDataConvert, ...
                iIntMatStruct.ShortestPath,pIntItemLoc(pI1,1), ...
                pIntItemLoc(pI1,2),iIntMatStruct.InterMatrix);
        catch
            display(['Notifying: Error occurs for iInterItems(', ...
                num2str(pI1),',:), possibly out of memory.']);
        end
    end
    oBetweenness = pOutData;
    oBetweenness(pIntItemCk) = pBetweenness;
    oShortPathTravel = pOutData;
    oShortPathTravel(pIntItemCk) = pShortPathTravel;
end
end

function [oBetweenness,oExitTag] = GetInteractBetweenP(fDataConvert, ...
    iShortPathMat,iItem1Loc,iItem2Loc,iInterMatrix)
if nargin == 3
    pDistToItem1 = iShortPathMat(iItem1Loc,:);
    pLocDTItem1 = fDataConvert(find(pDistToItem1));
    pLength = length(pLocDTItem1);
    oBetweenness = 0;
    if eq(pLength,0)
        oExitTag = 4;
        return;
    end
    for pI1 = 1:(pLength-1)
        pLocCurrent = pLocDTItem1(pI1);
        pLocOthers = pLocDTItem1((pI1+1):pLength);
        pCkDist = iShortPathMat(pLocCurrent,pLocOthers) == ...
            (pDistToItem1(pLocCurrent) + pDistToItem1(pLocOthers));
        if any(pCkDist)
            oBetweenness = oBetweenness + nnz(pCkDist);
        end
    end
    oExitTag = 1;
elseif nargin == 4
    pDistItem1To2 = iShortPathMat(iItem1Loc,iItem2Loc);
    if eq(pDistItem1To2,0)
        oBetweenness = 0;
        oExitTag = 5;
        return;
    end
    pDistToItem1 = iShortPathMat(iItem1Loc,:);
    pDistToItem2 = iShortPathMat(iItem2Loc,:);
    pCkDTItem1 = eq(pDistToItem1,0);
    pCkDTItem2 = eq(pDistToItem2,0);
    pDistToItem1Pass2 = pDistToItem2 + pDistItem1To2;
    for pI1 = 1:size(iShortPathMat,1)
        pDist = pDistToItem1(pI1) + pDistToItem1Pass2;
        pCkDist = or(or(pCkDTItem1(pI1),pCkDTItem2), ...
            (iShortPathMat(pI1,:) ~= pDist));
        if any(pCkDist)
            iShortPathMat(pI1,pCkDist) = 0;
        end
    end
    oBetweenness = nnz(iShortPathMat);
    oExitTag = 1;
elseif nargin == 5 && isempty(iItem2Loc)
    pDistToItem1 = iShortPathMat(iItem1Loc,:);
    pCkDTItem1 = eq(pDistToItem1,0);
    if all(pCkDTItem1)
        oBetweenness = 0;
        oExitTag = 4;
        return;
    elseif any(pCkDTItem1)
        iShortPathMat(pCkDTItem1,:) = 0;
        iShortPathMat(:,pCkDTItem1) = 0;
    end
    pLocDTItem1 = fDataConvert(find(~pCkDTItem1));
    pLength = length(pLocDTItem1);
    iShortPathMat = triu(iShortPathMat);
    for pI1 = 1:(pLength-1)
        pLocCurrent = pLocDTItem1(pI1);
        pLocOthers = pLocDTItem1((pI1+1):pLength);
        pCkDist = iShortPathMat(pLocCurrent,pLocOthers) ~= ...
            (pDistToItem1(pLocOthers) + pDistToItem1(pLocCurrent));
        if any(pCkDist)
            iShortPathMat(pLocCurrent,pLocOthers(pCkDist)) = 0;
        end
    end
    oBetweenness = nnz(iShortPathMat);
    oExitTag = 2;
    if oBetweenness > 0
        [pShortPathItems,pShortPathItems(:,2)] = find(iShortPathMat);
        pIntMatLength = size(iInterMatrix,1);
        for pI1 = 1:oBetweenness
            pNodeNotSearch = true(pIntMatLength,1);
            [pCkPath,pCkPass] = f_NodePathTravel( ...
                pShortPathItems(pI1,1),pShortPathItems(pI1,2),iItem1Loc);
            if ~and(pCkPath,pCkPass)
                oExitTag = 3;
                return;
            end
        end
    end
else
    pDistItem1To2 = iShortPathMat(iItem1Loc,iItem2Loc);
    if eq(pDistItem1To2,0)
        oBetweenness = 0;
        oExitTag = 5;
        return;
    end
    pIMLength = size(iShortPathMat,1);
    pDistToItem1 = iShortPathMat(iItem1Loc,:);
    pDistToItem2 = iShortPathMat(iItem2Loc,:);
    pCkDTItem1 = eq(pDistToItem1,0);
    pCkDTItem2 = eq(pDistToItem2,0);
    pDistToItem1Pass2 = pDistToItem2 + pDistItem1To2;
    for pI1 = 1:pIMLength
        pDist = pDistToItem1(pI1) + pDistToItem1Pass2;
        pCkDist = or(or(pCkDTItem1(pI1),pCkDTItem2), ...
            (iShortPathMat(pI1,:) ~= pDist));
        if any(pCkDist)
            iShortPathMat(pI1,pCkDist) = 0;
        end
    end
    oExitTag = 2;
    oBetweenness = nnz(iShortPathMat);
    if oBetweenness > 0
        [pShortPathItems,pShortPathItems(:,2)] = find(iShortPathMat);
        for pI1 = 1:oBetweenness
            pNodeNotSearch = true(pIMLength,1);
            [pCkPath,pCkPass] = f_EdgePathTravel( ...
                pShortPathItems(pI1,1),pShortPathItems(pI1,2), ...
                [iItem1Loc,iItem2Loc]);
            if ~and(pCkPath,all(pCkPass))
                oExitTag = 3;
                return;
            end
        end
    end
    
end

function [o_CkConnect,o_CkPass] = f_NodePathTravel( ...
        i_ItemSearch,i_ItemConnect,i_ItemPass)
    pNodeNotSearch(i_ItemSearch) = false;
    p_DeepItems = and( any(iInterMatrix(:,i_ItemSearch),2), ...
        pNodeNotSearch );
    if any(p_DeepItems)
        if p_DeepItems(i_ItemConnect)
            o_CkConnect = true;
            o_CkPass = false;
        else
            if p_DeepItems(i_ItemPass)
                o_CkConnect = f_PathConnect(p_DeepItems,i_ItemConnect);
                o_CkPass = true;
            else
                [o_CkConnect,o_CkPass] = f_NodePathTravel( ...
                    p_DeepItems,i_ItemConnect,i_ItemPass);
            end
        end
    else
        o_CkConnect = false;
        o_CkPass = false;
    end
end

function [o_CkConnect,o_CkPass] = f_EdgePathTravel( ...
        i_ItemSearch,i_ItemConnect,i_ItemsPass)
    pNodeNotSearch(i_ItemSearch) = false;
    p_DeepItems = and( any(iInterMatrix(:,i_ItemSearch),2), ...
        pNodeNotSearch );
    if any(p_DeepItems)
        if p_DeepItems(i_ItemConnect)
            o_CkConnect = true;
            o_CkPass = false;
        else
            o_CkPass = p_DeepItems(i_ItemsPass);
            if any(o_CkPass)
                if all(o_CkPass)
                    o_CkConnect = f_PathConnect(p_DeepItems,i_ItemConnect);
                else
                    [o_CkConnect,p_CkPass] = f_EdgePathTravel( ...
                        p_DeepItems,i_ItemConnect,i_ItemsPass(~o_CkPass));
                    o_CkPass(~o_CkPass) = p_CkPass;
                end
            else
                [o_CkConnect,o_CkPass] = f_EdgePathTravel( ...
                    p_DeepItems,i_ItemConnect,i_ItemsPass);
            end
        end
    else
        o_CkConnect = false;
        o_CkPass = false;
    end
end

function o_CkConnect = f_PathConnect(i_ItemSearch,i_ItemConnect)
    pNodeNotSearch(i_ItemSearch) = false;
    p_DeepItems = and( any(iInterMatrix(:,i_ItemSearch),2), ...
        pNodeNotSearch );
    if any(p_DeepItems)
        if p_DeepItems(i_ItemConnect)
            o_CkConnect = true;
        else
            o_CkConnect = f_PathConnect(p_DeepItems,i_ItemConnect);
        end
    else
        o_CkConnect = false;
    end
end

end
