function oInterStruct = GetInteractMatrix(iInteract,iInterItems,iIsDirect)
error(nargchk(1,3,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if nargin < 3
    iIsDirect = false;
elseif ~islogical(iIsDirect)
    error(pErrId,'The data type of "iIsDirect" should be logical.');
end
if nargin < 2
    iInterItems = [];
end
if isempty(iInterItems)
    oInterStruct.InterItems = unique(iInteract(:));
else
    oInterStruct.InterItems = iInterItems;
end
if size(iInteract,2) ~= 2
    error(pErrId,'iInteract should be an m-by-2 matrix.');
end
[pInterCk,pInterLoc] = ismember(iInteract,oInterStruct.InterItems);
pInterCk = all(pInterCk,2);
if any(~pInterCk)
    pInterLoc = pInterLoc(pInterCk,:);
    warning(pErrId,['Some items of iInteract do not exist in ' ...
        'iInterItems. These interactions will be ignored.']);
end
pItemsLength = size(oInterStruct.InterItems,1);
if iIsDirect
    oInterStruct.InterMatrix = sparse(pInterLoc(:,1),pInterLoc(:,2), ...
        true(size(pInterLoc,1),1),pItemsLength,pItemsLength);
else
    pInterLoc = unique([pInterLoc;pInterLoc(:,[2,1])],'rows');
    oInterStruct.InterMatrix = sparse(pInterLoc(:,1),pInterLoc(:,2), ...
        true(size(pInterLoc,1),1),pItemsLength,pItemsLength);
end
end
