function oNeighbors = GetInteractNeighbor(iInteract,iIntMatStruct, ...
    iItemsId,iItemsGOTerm,iGOAnceStruct)
error(nargchk(5,5,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if size(iInteract,2) ~= 2
    error(pErrId,'iInteract should be an m-by-2 matrix.');
end
if ~isstruct(iIntMatStruct) || ~all(ismember( ...
        {'InterItems';'InterMatrix'},fieldnames(iIntMatStruct)))
    error(pErrId,'iIntMatStruct should be a InteractMatrix structure.');
end
pIMSize = size(iIntMatStruct.InterMatrix,1);
if pIMSize ~= size(iIntMatStruct.InterMatrix,2)
    error(pErrId,'iIntMatStruct.InterMatrix should be an m-by-m matrix.');
end
if pIMSize ~= size(iIntMatStruct.InterItems,1)
    error(pErrId,'iIntMatStruct.InterItems should be an m-by-1 vector.');
end
if pIMSize < 2^8
    fIntType = @uint8;
    pIntType = 'uint8';
elseif pIMSize < 2^16
    fIntType = @uint16;
    pIntType = 'uint16';
elseif pIMSize < 2^32
    fIntType = @uint32;
    pIntType = 'uint32';
elseif pIMSize < 2^64
    fIntType = @int64;
    pIntType = 'uint64';
else
    error(pErrId,'Out of memory.');
end
iIntMatStruct.InterMatrix(sub2ind( ...
    [pIMSize,pIMSize],1:pIMSize,1:pIMSize)) = false;
iIntMatStruct.ShortestPath(sub2ind( ...
    [pIMSize,pIMSize],1:pIMSize,1:pIMSize)) = 0;
pIntLength = size(iInteract,1);
[pIntCk,pIntLoc] = ismember(iInteract,iIntMatStruct.InterItems);
pIntCk = all(pIntCk,2);
pIMConnect = sum(iIntMatStruct.InterMatrix,1);
oNeighbors.InterItemDegree = zeros(pIntLength,2);
oNeighbors.InterItemDegree(pIntCk,:) = pIMConnect(pIntLoc(pIntCk,:));
pItemsEqCk = and(pIntCk,eq(pIntLoc(:,1),pIntLoc(:,2)));
oNeighbors.ItemsIsIdentical = double(pItemsEqCk);
pItemsEqDegree = pIMConnect(pIntLoc(pItemsEqCk,1));
pIntCk(pItemsEqCk) = false;
pIntLoc = pIntLoc(pIntCk,:);
pIntLocLength = size(pIntLoc,1);
oNeighbors.ItemsDirectInteract = zeros(pIntLength,1);
oNeighbors.ItemsDirectInteract(pIntCk) = iIntMatStruct.InterMatrix( ...
    sub2ind([pIMSize,pIMSize],pIntLoc(:,1),pIntLoc(:,2)));
oNeighbors.ItemsShortDistance = zeros(pIntLength,1);
oNeighbors.ItemsShortDistance(pIntCk) = iIntMatStruct.ShortestPath( ...
    sub2ind([pIMSize,pIMSize],pIntLoc(:,1),pIntLoc(:,2)));
oNeighbors.InterBetweenness = zeros(pIntLength,1);
oNeighbors.InterBetweenness(pIntCk) = GetInteractBetween( ...
    iIntMatStruct,iIntMatStruct.InterItems(pIntLoc),false);
pCommNeib1st = zeros(pIntLocLength,1);
pCommNeib2nd = zeros(pIntLocLength,1);
pCommNeib3rd = zeros(pIntLocLength,1);
pTopOverlap1st = zeros(pIntLocLength,1);
pTopOverlap2nd = zeros(pIntLocLength,1);
pTopOverlap3rd = zeros(pIntLocLength,1);
pClusterCoeff1st = zeros(pIntLocLength,1);
pClusterCoeff2nd = zeros(pIntLocLength,1);
pClusterCoeff3rd = zeros(pIntLocLength,1);
pCN1stInterA = cell(pIntLocLength,1);
pCN1stInterB = cell(pIntLocLength,1);
pCN1stIntra = cell(pIntLocLength,1);
pCN2ndInterA = cell(pIntLocLength,1);
pCN2ndInterB = cell(pIntLocLength,1);
pCN2ndIntra = cell(pIntLocLength,1);
pCN3rdInterA = cell(pIntLocLength,1);
pCN3rdInterB = cell(pIntLocLength,1);
pCN3rdIntra = cell(pIntLocLength,1);
pIntLoc = fIntType(pIntLoc);
for pI1 = 1:pIntLocLength
    pIL1 = pIntLoc(pI1,1);
    pIL2 = pIntLoc(pI1,2);
    pIL1N1stCk = iIntMatStruct.InterMatrix(:,pIL1);
    pIL2N1stCk = iIntMatStruct.InterMatrix(:,pIL2);
    pIL1N1stCk(pIL2) = false;
    pIL2N1stCk(pIL1) = false;
    pCN1stCk = and(pIL1N1stCk,pIL2N1stCk);
    if any(pCN1stCk)
        pCN1st = fIntType(find(pCN1stCk));
        pCommNeib1st(pI1) = length(pCN1st);
        pCN1stInterA{pI1} = [repmat(pIL1,pCommNeib1st(pI1),1), ...
            pCN1st; repmat(pIL2,pCommNeib1st(pI1),1), pCN1st];
        pCN1stInterB{pI1} = [repmat(pIL1,pCommNeib1st(pI1),1), ...
            pCN1st, repmat(pIL2,pCommNeib1st(pI1),1)];
        [pIntraIdx1,pIntraIdx2] = find(triu( ...
            iIntMatStruct.InterMatrix(pCN1stCk,pCN1stCk)));
        pCN1stIntraNo = length(pIntraIdx1);
        if pCN1stIntraNo > 0
            pCN1stIntra{pI1} = [pCN1st(pIntraIdx1),pCN1st(pIntraIdx2)];
        end
        pTopOverlap1st(pI1) = pCommNeib1st(pI1) ...
            / min(nnz(pIL1N1stCk),nnz(pIL2N1stCk));
        if eq(pCommNeib1st(pI1),1)
            pClusterCoeff1st(pI1) = 1;
        else
            pClusterCoeff1st(pI1) = (2 * pCN1stIntraNo) / ...
                (pCommNeib1st(pI1) * (pCommNeib1st(pI1) - 1));
        end
    end
    pIL1N2nd = fIntType(find(and(pIL1N1stCk, ...
        eq(iIntMatStruct.ShortestPath(:,pIL2),2))));
    pIL2N2nd = fIntType(find(and(pIL2N1stCk, ...
        eq(iIntMatStruct.ShortestPath(:,pIL1),2))));
    pIntraMat = iIntMatStruct.InterMatrix(pIL1N2nd,pIL2N2nd);
    if nnz(pIntraMat) > 0
        pIL1N2nd = pIL1N2nd(any(pIntraMat,2));
        pIL1N2ndNo = length(pIL1N2nd);
        pIL2N2nd = pIL2N2nd(any(pIntraMat,1));
        pIL2N2ndNo = length(pIL2N2nd);
        pCommNeib2nd(pI1) = pIL1N2ndNo + pIL2N2ndNo;
        pIntraMat = iIntMatStruct.InterMatrix(pIL1N2nd,pIL2N2nd);
        [pIntraIdx1,pIntraIdx2] = find(pIntraMat);
        if eq(pIL1N2ndNo,1)
            pIntraIdx1 = pIntraIdx1';
            pIntraIdx2 = pIntraIdx2';
        end
        pCN2ndIntraNo = length(pIntraIdx1);
        pCN2ndIntra{pI1} = [pIL1N2nd(pIntraIdx1),pIL2N2nd(pIntraIdx2)];
        pCN2ndInterA{pI1} = [repmat(pIL1,pIL1N2ndNo,1), pIL1N2nd; ...
            repmat(pIL2,pIL2N2ndNo,1), pIL2N2nd];
        pCN2ndInterB{pI1} = [repmat(pIL1,pCN2ndIntraNo,1), ...
            pCN2ndIntra{pI1}, repmat(pIL2,pCN2ndIntraNo,1)];
        pTopOverlap2nd(pI1) = pCommNeib2nd(pI1) ...
            / nnz(or(pIL1N1stCk,pIL2N1stCk));
        pClusterCoeff2nd(pI1) = pCN2ndIntraNo/(pIL1N2ndNo*pIL2N2ndNo);
    end
    pIL1N3rd = fIntType(find(and(pIL1N1stCk, ...
        eq(iIntMatStruct.ShortestPath(:,pIL2),3))));
    pIL2N3rd = fIntType(find(and(pIL2N1stCk, ...
        eq(iIntMatStruct.ShortestPath(:,pIL1),3))));
    pIntraMat = eq(iIntMatStruct.ShortestPath(pIL1N3rd,pIL2N3rd),2);
    if nnz(pIntraMat) > 0
        pIL1N3rd = pIL1N3rd(any(pIntraMat,2));
        pIL1N3rdNo = length(pIL1N3rd);
        pIL2N3rd = pIL2N3rd(any(pIntraMat,1));
        pIL2N3rdNo = length(pIL2N3rd);
        pCommNeib3rd(pI1) = pIL1N3rdNo + pIL2N3rdNo;
        pIntraMat = eq( ...
            iIntMatStruct.ShortestPath(pIL1N3rd,pIL2N3rd),2);
        [pIntraIdx1,pIntraIdx2] = find(pIntraMat);
        if eq(pIL1N3rdNo,1)
            pIntraIdx1 = pIntraIdx1';
            pIntraIdx2 = pIntraIdx2';
        end
        pCN3rdIntraNo = length(pIntraIdx1);
        pCN3rdIntra{pI1} = [pIL1N3rd(pIntraIdx1),pIL2N3rd(pIntraIdx2)];
        pCN3rdInterA{pI1} = [repmat(pIL1,pIL1N3rdNo,1), pIL1N3rd; ...
            repmat(pIL2,pIL2N3rdNo,1), pIL2N3rd];
        pCN3rdInterB{pI1} = [repmat(pIL1,pCN3rdIntraNo,1), ...
            pCN3rdIntra{pI1}, repmat(pIL2,pCN3rdIntraNo,1)];
        pTopOverlap3rd(pI1) = pCommNeib3rd(pI1) ...
            / nnz(or(pIL1N1stCk,pIL2N1stCk));
        pClusterCoeff3rd(pI1) = pCN3rdIntraNo/(pIL1N3rdNo*pIL2N3rdNo);
    end
end

pDataSize = 18;
pCN1stInterCk = ~cellfun('isempty',pCN1stInterA);
pCN1stIntraCk = ~cellfun('isempty',pCN1stIntra);
[pCN1stInterA,~,pCN1stInterALoc] = CellArrayDataCat(pCN1stInterA,pIntType);
[pCN1stInterB,~,pCN1stInterBLoc] = CellArrayDataCat(pCN1stInterB,pIntType);
[pCN1stIntra,~,pCN1stIntraLoc] = CellArrayDataCat(pCN1stIntra,pIntType);
pCN2ndIntCk = ~cellfun('isempty',pCN2ndInterA);
[pCN2ndInterA,~,pCN2ndInterALoc] = CellArrayDataCat(pCN2ndInterA,pIntType);
[pCN2ndInterB,~,pCN2ndInterBLoc] = CellArrayDataCat(pCN2ndInterB,pIntType);
[pCN2ndIntra,~,pCN2ndIntraLoc] = CellArrayDataCat(pCN2ndIntra,pIntType);
pCN3rdIntCk = ~cellfun('isempty',pCN3rdInterA);
[pCN3rdInterA,~,pCN3rdInterALoc] = CellArrayDataCat(pCN3rdInterA,pIntType);
[pCN3rdInterB,~,pCN3rdInterBLoc] = CellArrayDataCat(pCN3rdInterB,pIntType);
[pCN3rdIntra,~,pCN3rdIntraLoc] = CellArrayDataCat(pCN3rdIntra,pIntType);
[pInt2Uni,pLocInInt2Uni] = GetInteractUnique([pCN1stInterA; ...
    pCN1stIntra;pCN2ndInterA;pCN2ndIntra;pCN3rdInterA;pCN3rdIntra]);
pInt2UniIdx = cumsum([size(pCN1stInterA,1),size(pCN1stIntra,1), ...
    size(pCN2ndInterA,1),size(pCN2ndIntra,1), ...
    size(pCN3rdInterA,1),size(pCN3rdIntra,1)]);
pInt2UniGOSimi = GetInteractSimilarGO(iIntMatStruct.InterItems( ...
    pInt2Uni),iItemsId,iItemsGOTerm,iGOAnceStruct);
pCN1IntALocInInt2Uni = pLocInInt2Uni(1:pInt2UniIdx(1));
pCN1IntASimi = cell(pIntLocLength,1);
pCN1IntASimi(:) = {zeros(1,pDataSize)};
pCN1IntASimi(pCN1stInterCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN1IntALocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN1IntALocInInt2Uni(x),:),1) ], ...
    pCN1stInterALoc(pCN1stInterCk),'UniformOutput',false);
pCN1IntraLocInInt2Uni = pLocInInt2Uni((pInt2UniIdx(1)+1):pInt2UniIdx(2));
pCN1IntraSimi = cell(pIntLocLength,1);
pCN1IntraSimi(:) = {zeros(1,pDataSize)};
pCN1IntraSimi(pCN1stIntraCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN1IntraLocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN1IntraLocInInt2Uni(x),:),1) ], ...
    pCN1stIntraLoc(pCN1stIntraCk),'UniformOutput',false);
pCN2IntALocInInt2Uni = pLocInInt2Uni((pInt2UniIdx(2)+1):pInt2UniIdx(3));
pCN2IntASimi = cell(pIntLocLength,1);
pCN2IntASimi(:) = {zeros(1,pDataSize)};
pCN2IntASimi(pCN2ndIntCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN2IntALocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN2IntALocInInt2Uni(x),:),1) ], ...
    pCN2ndInterALoc(pCN2ndIntCk),'UniformOutput',false);
pCN2IntraLocInInt2Uni = pLocInInt2Uni((pInt2UniIdx(3)+1):pInt2UniIdx(4));
pCN2IntraSimi = cell(pIntLocLength,1);
pCN2IntraSimi(:) = {zeros(1,pDataSize)};
pCN2IntraSimi(pCN2ndIntCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN2IntraLocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN2IntraLocInInt2Uni(x),:),1) ], ...
    pCN2ndIntraLoc(pCN2ndIntCk),'UniformOutput',false);
pCN3IntALocInInt2Uni = pLocInInt2Uni((pInt2UniIdx(4)+1):pInt2UniIdx(5));
pCN3IntASimi = cell(pIntLocLength,1);
pCN3IntASimi(:) = {zeros(1,pDataSize)};
pCN3IntASimi(pCN3rdIntCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN3IntALocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN3IntALocInInt2Uni(x),:),1) ], ...
    pCN3rdInterALoc(pCN3rdIntCk),'UniformOutput',false);
pCN3IntraLocInInt2Uni = pLocInInt2Uni((pInt2UniIdx(5)+1):pInt2UniIdx(6));
pCN3IntraSimi = cell(pIntLocLength,1);
pCN3IntraSimi(:) = {zeros(1,pDataSize)};
pCN3IntraSimi(pCN3rdIntCk) = cellfun(@(x)[ ...
    max(pInt2UniGOSimi(pCN3IntraLocInInt2Uni(x),:),[],1), ...
    mean(pInt2UniGOSimi(pCN3IntraLocInInt2Uni(x),:),1) ], ...
    pCN3rdIntraLoc(pCN3rdIntCk),'UniformOutput',false);
pInt3UniGOSimi = GetInteractSimilarGO(iIntMatStruct.InterItems( ...
    pCN1stInterB),iItemsId,iItemsGOTerm,iGOAnceStruct);
pCN1IntBSimi = cell(pIntLocLength,1);
pCN1IntBSimi(:) = {zeros(1,pDataSize)};
pCN1IntBSimi(pCN1stInterCk) = cellfun(@(x)[ ...
    max(pInt3UniGOSimi(x,:),[],1), mean(pInt3UniGOSimi(x,:),1) ], ...
    pCN1stInterBLoc(pCN1stInterCk),'UniformOutput',false);
pInt4UniGOSimi = GetInteractSimilarGO( ...
    iIntMatStruct.InterItems([pCN2ndInterB;pCN3rdInterB]), ...
    iItemsId,iItemsGOTerm,iGOAnceStruct);
pInt4UniIdx = cumsum([size(pCN2ndInterB,1),size(pCN3rdInterB,1)]);
pCN2IntBLocInInt4Uni = 1:pInt4UniIdx(1);
pCN2IntBSimi = cell(pIntLocLength,1);
pCN2IntBSimi(:) = {zeros(1,pDataSize)};
pCN2IntBSimi(pCN2ndIntCk) = cellfun(@(x)[ ...
    max(pInt4UniGOSimi(pCN2IntBLocInInt4Uni(x),:),[],1), ...
    mean(pInt4UniGOSimi(pCN2IntBLocInInt4Uni(x),:),1) ], ...
    pCN2ndInterBLoc(pCN2ndIntCk),'UniformOutput',false);
pCN3IntBLocInInt4Uni = (pInt4UniIdx(1)+1):pInt4UniIdx(2);
pCN3IntBSimi = cell(pIntLocLength,1);
pCN3IntBSimi(:) = {zeros(1,pDataSize)};
pCN3IntBSimi(pCN3rdIntCk) = cellfun(@(x)[ ...
    max(pInt4UniGOSimi(pCN3IntBLocInInt4Uni(x),:),[],1), ...
    mean(pInt4UniGOSimi(pCN3IntBLocInInt4Uni(x),:),1) ], ...
    pCN3rdInterBLoc(pCN3rdIntCk),'UniformOutput',false);

pConstruct1 = zeros(pIntLength,1);
pConstruct1(pItemsEqCk) = pItemsEqDegree;
oNeighbors.CommonNeighbor_1stOrder = pConstruct1;
oNeighbors.CommonNeighbor_1stOrder(pIntCk) = pCommNeib1st;
oNeighbors.CommonNeighbor_2ndOrder = pConstruct1;
oNeighbors.CommonNeighbor_2ndOrder(pIntCk) = pCommNeib2nd;
oNeighbors.CommonNeighbor_3rdOrder = pConstruct1;
oNeighbors.CommonNeighbor_3rdOrder(pIntCk) = pCommNeib3rd;
pConstruct2 = zeros(pIntLength,1);
pConstruct2(pItemsEqCk) = 1;
oNeighbors.TopologyOverlap_1stOrder = pConstruct2;
oNeighbors.TopologyOverlap_1stOrder(pIntCk) = pTopOverlap1st;
oNeighbors.TopologyOverlap_2ndOrder = pConstruct2;
oNeighbors.TopologyOverlap_2ndOrder(pIntCk) = pTopOverlap2nd;
oNeighbors.TopologyOverlap_3rdOrder = pConstruct2;
oNeighbors.TopologyOverlap_3rdOrder(pIntCk) = pTopOverlap3rd;
oNeighbors.ClusterCoeff_1stOrder = pConstruct2;
oNeighbors.ClusterCoeff_1stOrder(pIntCk) = pClusterCoeff1st;
oNeighbors.ClusterCoeff_2ndOrder = pConstruct2;
oNeighbors.ClusterCoeff_2ndOrder(pIntCk) = pClusterCoeff2nd;
oNeighbors.ClusterCoeff_3rdOrder = pConstruct2;
oNeighbors.ClusterCoeff_3rdOrder(pIntCk) = pClusterCoeff3rd;
oNeighbors.InterASimi_1stOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterASimi_1stOrder(pIntCk,:) = CellArrayDataCat(pCN1IntASimi);
oNeighbors.InterBSimi_1stOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterBSimi_1stOrder(pIntCk,:) = CellArrayDataCat(pCN1IntBSimi);
oNeighbors.IntraSimi_1stOrder = zeros(pIntLength,pDataSize);
oNeighbors.IntraSimi_1stOrder(pIntCk,:) = CellArrayDataCat(pCN1IntraSimi);
oNeighbors.InterASimi_2ndOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterASimi_2ndOrder(pIntCk,:) = CellArrayDataCat(pCN2IntASimi);
oNeighbors.InterBSimi_2ndOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterBSimi_2ndOrder(pIntCk,:) = CellArrayDataCat(pCN2IntBSimi);
oNeighbors.IntraSimi_2ndOrder = zeros(pIntLength,pDataSize);
oNeighbors.IntraSimi_2ndOrder(pIntCk,:) = CellArrayDataCat(pCN2IntraSimi);
oNeighbors.InterASimi_3rdOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterASimi_3rdOrder(pIntCk,:) = CellArrayDataCat(pCN3IntASimi);
oNeighbors.InterBSimi_3rdOrder = zeros(pIntLength,pDataSize);
oNeighbors.InterBSimi_3rdOrder(pIntCk,:) = CellArrayDataCat(pCN3IntBSimi);
oNeighbors.IntraSimi_3rdOrder = zeros(pIntLength,pDataSize);
oNeighbors.IntraSimi_3rdOrder(pIntCk,:) = CellArrayDataCat(pCN3IntraSimi);

end
