function oGOSimilarData = GetInteractSimilarGO(iInteract, ...
    iItemsId,iItemsGOTerm,iGOAnceStruct)
error(nargchk(4,4,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
pIntColNo = size(iInteract,2);
if all(~eq([2,3,4],pIntColNo))
    error(pErrId,['iInteract should be an m-by-2, m-by-3, ' ...
        'or m-by-4 matrix.']);
end
if size(iItemsId,1) ~= size(iItemsGOTerm,1)
    error(pErrId,['The element number of "iItemsId" ' ...
        'and "iInterItemGOTerms" should be equal.']);
end
if ~isstruct(iGOAnceStruct) || ~all(ismember({'GOTermsId'; ...
        'GOTermsDepth';'GOTermsNameSpace';'RootNameSpace'; ...
        'AncestorLoc'}, fieldnames(iGOAnceStruct)))
    error(pErrId,'iGOAnceStruct should be a GOAncestors structure.');
end
pCkInterItems = ~cellfun('isempty',iItemsGOTerm);
iItemsId = iItemsId(pCkInterItems);
iItemsGOTerm = iItemsGOTerm(pCkInterItems);
[pIGOTDataCat,~,pIGOTCatIdx] = CellArrayDataCat(iItemsGOTerm);
[pCkInAST,pLocInAST] = ismember(pIGOTDataCat,iGOAnceStruct.GOTermsId);
if any(~pCkInAST)
    warning(pErrId,['Some iItemsGOTerm can not be found in ' ...
        '"iGOAnceStruct.GOTermsId", and will be ignored.']);
end
pLocInAST = cellfun(@(x)nonzeros(pLocInAST(x)), ...
    pIGOTCatIdx,'UniformOutput',false);
pIGOTLocInAST = cell(size(iItemsId,1),3);
for pI5 = 1:size(iItemsId,1)
    pNameSpace = iGOAnceStruct.GOTermsNameSpace(pLocInAST{pI5});
    for pI6 = 1:3
        pIGOTLocInAST{pI5,pI6} = pLocInAST{pI5}(eq(pNameSpace,pI6));
    end
end
[pIntCk,pIntLocInIGOT] = ismember(iInteract,iItemsId);
pIntCk = all(pIntCk,2);
pIntLocInIGOT = pIntLocInIGOT(pIntCk,:);
pBlockLength = 9;
pGOIdx = 1:pBlockLength/3:pBlockLength;
switch pIntColNo
    case 2
        pSimiData = f_Int2GOSimi(pIntLocInIGOT,pIGOTLocInAST,pGOIdx);
    case 3
        pSimiData = f_Int3GOSimi(pIntLocInIGOT,pIGOTLocInAST,pGOIdx);
    case 4
        pSimiData = f_Int4GOSimi(pIntLocInIGOT,pIGOTLocInAST,pGOIdx);
end
oGOSimilarData = zeros(size(iInteract,1),pBlockLength);
oGOSimilarData(pIntCk,:) = CellArrayDataCat(pSimiData);
for pI6 = 1:3
    ptIdx = pGOIdx(pI6):(pGOIdx(pI6)+(pBlockLength/3)-1);
    oGOSimilarData(:,ptIdx) = oGOSimilarData(:,ptIdx) ./ ...
        double(max( iGOAnceStruct.GOTermsDepth( ...
        eq(iGOAnceStruct.GOTermsNameSpace,pI6)) ));
end

function o_SimiData = f_Int2GOSimi(i_IntLocInIGOT,i_IGOTLocInAST,i_GOIdx)
o_SimiData = cell(size(i_IntLocInIGOT,1),1);
o_SimiData(:) = {zeros(1,pBlockLength)};
for p_I5 = 1:size(i_IntLocInIGOT,1)
    for p_I6 = 1:3
        pItem1GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,1),p_I6};
        pItem2GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,2),p_I6};
        pItem1GOSize = length(pItem1GOLoc);
        pItem2GOSize = length(pItem2GOLoc);
        if any(eq([pItem1GOSize,pItem2GOSize],0))
            continue;
        end
        pItem1AnceGOLoc = cell(pItem1GOSize,1);
        for pI1 = 1:pItem1GOSize
            pItem1AnceGOLoc{pI1} = [pItem1GOLoc(pI1); ...
                iGOAnceStruct.AncestorLoc{pItem1GOLoc(pI1)}];
        end
        pItem2AnceGOLoc = cell(pItem2GOSize,1);
        for pI2 = 1:pItem2GOSize
            pItem2AnceGOLoc{pI2} = [pItem2GOLoc(pI2); ...
                iGOAnceStruct.AncestorLoc{pItem2GOLoc(pI2)}];
        end
        pCommAnceDepth = zeros(pItem1GOSize,pItem2GOSize);
        for pI1 = 1:pItem1GOSize
            for pI2 = 1:pItem2GOSize
                pCkCommAnce = ismember(pItem1AnceGOLoc{pI1}, ...
                    pItem2AnceGOLoc{pI2});
                if any(pCkCommAnce)
                    pCommAnceDepth(pI1,pI2) = max( ...
                        iGOAnceStruct.GOTermsDepth( ...
                        pItem1AnceGOLoc{pI1}(pCkCommAnce)));
                end
            end
        end
        o_SimiData{p_I5}(i_GOIdx(p_I6)) = max(pCommAnceDepth(:));
        o_SimiData{p_I5}(i_GOIdx(p_I6)+1) = mean(pCommAnceDepth(:));
        o_SimiData{p_I5}(i_GOIdx(p_I6)+2) = mean(  ...
            [max(pCommAnceDepth,[],1),max(pCommAnceDepth,[],2)'] );
    end
end
end

function o_SimiData = f_Int3GOSimi(i_IntLocInIGOT,i_IGOTLocInAST,i_GOIdx)
o_SimiData = cell(size(i_IntLocInIGOT,1),1);
o_SimiData(:) = {zeros(1,pBlockLength)};
for p_I5 = 1:size(i_IntLocInIGOT,1)
    for p_I6 = 1:3
        pItem1GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,1),p_I6};
        pItem2GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,2),p_I6};
        pItem3GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,3),p_I6};
        pItem1GOSize = length(pItem1GOLoc);
        pItem2GOSize = length(pItem2GOLoc);
        pItem3GOSize = length(pItem3GOLoc);
        if any(eq([pItem1GOSize,pItem2GOSize,pItem3GOSize],0))
            continue;
        end
        pItem1AnceGOLoc = cell(pItem1GOSize,1);
        for pI1 = 1:pItem1GOSize
            pItem1AnceGOLoc{pI1} = [pItem1GOLoc(pI1); ...
                iGOAnceStruct.AncestorLoc{pItem1GOLoc(pI1)}];
        end
        pItem2AnceGOLoc = cell(pItem2GOSize,1);
        for pI2 = 1:pItem2GOSize
            pItem2AnceGOLoc{pI2} = [pItem2GOLoc(pI2); ...
                iGOAnceStruct.AncestorLoc{pItem2GOLoc(pI2)}];
        end
        pItem3AnceGOLoc = cell(pItem3GOSize,1);
        for pI3 = 1:pItem3GOSize
            pItem3AnceGOLoc{pI3} = [pItem3GOLoc(pI3); ...
                iGOAnceStruct.AncestorLoc{pItem3GOLoc(pI3)}];
        end
        pItem12CACk = cell(pItem1GOSize,pItem2GOSize);
        for pI1 = 1:pItem1GOSize
            for pI2 = 1:pItem2GOSize
                pItem12CACk{pI1,pI2} = ismember( ...
                    pItem1AnceGOLoc{pI1},pItem2AnceGOLoc{pI2});
            end
        end
        pItem13CACk = cell(pItem1GOSize,pItem3GOSize);
        for pI1 = 1:pItem1GOSize
            for pI3 = 1:pItem3GOSize
                pItem13CACk{pI1,pI3} = ismember( ...
                    pItem1AnceGOLoc{pI1},pItem3AnceGOLoc{pI3});
            end
        end
        pCommAnceDepth = zeros(pItem1GOSize,pItem2GOSize,pItem3GOSize);
        for pI1 = 1:pItem1GOSize
            for pI2 = 1:pItem2GOSize
                for pI3 = 1:pItem3GOSize
                    pItem123CACk = and(pItem12CACk{pI1,pI2}, ...
                        pItem13CACk{pI1,pI3});
                    if any(pItem123CACk)
                        pCommAnceDepth(pI1,pI2,pI3) = max( ...
                            iGOAnceStruct.GOTermsDepth( ...
                            pItem1AnceGOLoc{pI1}(pItem123CACk)));
                    end
                end
            end
        end
        o_SimiData{p_I5}(i_GOIdx(p_I6)) = max(pCommAnceDepth(:));
        o_SimiData{p_I5}(i_GOIdx(p_I6)+1) = mean(pCommAnceDepth(:));
        pMaxCAD = max(pCommAnceDepth,[],1);
        o_SimiData{p_I5}(i_GOIdx(p_I6)+2) = mean( ...
            [max(max(pCommAnceDepth,[],2),[],3)',max(pMaxCAD,[],3), ...
            shiftdim(max(pMaxCAD,[],2),1)] );
    end
end
end

function o_SimiData = f_Int4GOSimi(i_IntLocInIGOT,i_IGOTLocInAST,i_GOIdx)
o_SimiData = cell(size(i_IntLocInIGOT,1),1);
o_SimiData(:) = {zeros(1,pBlockLength)};
for p_I5 = 1:size(i_IntLocInIGOT,1)
    for p_I6 = 1:3
        pItem1GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,1),p_I6};
        pItem2GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,2),p_I6};
        pItem3GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,3),p_I6};
        pItem4GOLoc = i_IGOTLocInAST{i_IntLocInIGOT(p_I5,4),p_I6};
        pItem1GOSize = length(pItem1GOLoc);
        pItem2GOSize = length(pItem2GOLoc);
        pItem3GOSize = length(pItem3GOLoc);
        pItem4GOSize = length(pItem4GOLoc);
        if any(eq([pItem1GOSize,pItem2GOSize, ...
                pItem3GOSize,pItem4GOSize],0))
            continue;
        end
        pItem1AnceGOLoc = cell(pItem1GOSize,1);
        for pI1 = 1:pItem1GOSize
            pItem1AnceGOLoc{pI1} = [pItem1GOLoc(pI1); ...
                iGOAnceStruct.AncestorLoc{pItem1GOLoc(pI1)}];
        end
        pItem2AnceGOLoc = cell(pItem2GOSize,1);
        for pI2 = 1:pItem2GOSize
            pItem2AnceGOLoc{pI2} = [pItem2GOLoc(pI2); ...
                iGOAnceStruct.AncestorLoc{pItem2GOLoc(pI2)}];
        end
        pItem3AnceGOLoc = cell(pItem3GOSize,1);
        for pI3 = 1:pItem3GOSize
            pItem3AnceGOLoc{pI3} = [pItem3GOLoc(pI3); ...
                iGOAnceStruct.AncestorLoc{pItem3GOLoc(pI3)}];
        end
        pItem4AnceGOLoc = cell(pItem4GOSize,1);
        for pI4 = 1:pItem4GOSize
            pItem4AnceGOLoc{pI4} = [pItem4GOLoc(pI4); ...
                iGOAnceStruct.AncestorLoc{pItem4GOLoc(pI4)}];
        end
        pItem12CACk = cell(pItem1GOSize,pItem2GOSize);
        for pI1 = 1:pItem1GOSize
            for pI2 = 1:pItem2GOSize
                pItem12CACk{pI1,pI2} = ismember( ...
                    pItem1AnceGOLoc{pI1},pItem2AnceGOLoc{pI2});
            end
        end
        pItem13CACk = cell(pItem1GOSize,pItem3GOSize);
        for pI1 = 1:pItem1GOSize
            for pI3 = 1:pItem3GOSize
                pItem13CACk{pI1,pI3} = ismember( ...
                    pItem1AnceGOLoc{pI1},pItem3AnceGOLoc{pI3});
            end
        end
        pItem14CACk = cell(pItem1GOSize,pItem4GOSize);
        for pI1 = 1:pItem1GOSize
            for pI4 = 1:pItem4GOSize
                pItem14CACk{pI1,pI4} = ismember( ...
                    pItem1AnceGOLoc{pI1},pItem4AnceGOLoc{pI4});
            end
        end
        pCommAnceDepth = zeros(pItem1GOSize,pItem2GOSize, ...
            pItem3GOSize,pItem4GOSize);
        for pI1 = 1:pItem1GOSize
            for pI2 = 1:pItem2GOSize
                for pI3 = 1:pItem3GOSize
                    pItem123CACk = and(pItem12CACk{pI1,pI2}, ...
                        pItem13CACk{pI1,pI3});
                    for pI4 = 1:pItem4GOSize
                        pItem1234CACk = and(pItem123CACk, ...
                            pItem14CACk{pI1,pI4});
                        if any(pItem1234CACk)
                            pCommAnceDepth(pI1,pI2,pI3,pI4) = max( ...
                                iGOAnceStruct.GOTermsDepth( ...
                                pItem1AnceGOLoc{pI1}(pItem1234CACk)));
                        end
                    end
                end
            end
        end
        o_SimiData{p_I5}(i_GOIdx(p_I6)) = max(pCommAnceDepth(:));
        o_SimiData{p_I5}(i_GOIdx(p_I6)+1) = mean(pCommAnceDepth(:));
        pMaxCAD12 = max(max(pCommAnceDepth,[],1),[],2);
        pMaxCAD34 = max(max(pCommAnceDepth,[],3),[],4);
        o_SimiData{p_I5}(i_GOIdx(p_I6)+2) = mean( [max(pMaxCAD34,[],2)', ...
            max(pMaxCAD34,[],1),shiftdim(max(pMaxCAD12,[],4),1), ...
            shiftdim(max(pMaxCAD12,[],3),2)] );
    end
end
end

end
