function [oInterUnique,oILocInO,oOLocInI] = GetInteractUnique(iInteract)
error(nargchk(1,1,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if ~(iscellstr(iInteract) || isnumeric(iInteract))
    error(pErrId,['Unrecognized data type of iInteract, should ' ...
        'be numeric or cellstr array.']);
end
if size(iInteract,2) ~= 2
    error(pErrId,'iInteract should be m-by-2 numeric or cellstr array.');
end
pInterStruct = GetInteractMatrix(iInteract);
[pIntUniLoc,pIntUniLoc(:,2)] = ind2sub(size(pInterStruct.InterMatrix), ...
    find(triu(pInterStruct.InterMatrix)));
oInterUnique = pInterStruct.InterItems(pIntUniLoc);
if nargout > 1
    [~,oILocInO] = CellStrIsMemberRows(iInteract,oInterUnique(:,[2,1]));
    [ptCk,ptLoc] = CellStrIsMemberRows(iInteract,oInterUnique);
    oILocInO(ptCk) = ptLoc(ptCk);
end
if nargout > 2
    [~,oOLocInI] = CellStrIsMemberRows(oInterUnique,iInteract(:,[2,1]));
    [ptCk,ptLoc] = CellStrIsMemberRows(oInterUnique,iInteract);
    oOLocInI(ptCk) = ptLoc(ptCk);
end

end
