function [oItemsCrossPair,oItemsLocate] = GetItemsCrossPair( ...
    iCellStrA,iCellStrB)
error(nargchk(1,2,nargin,'struct'));
fhErrorDim = @(x)error('The dimension of %s should be n-by-1.',x);
if nargin == 1
    iCellStrB = iCellStrA;
end
if isempty(iCellStrA) || isempty(iCellStrB)
    oItemsCrossPair = [];
    oItemsLocate = 0;
    return;
end
if size(iCellStrA,2) > 1
    iCellStrA = iCellStrA';
    if size(iCellStrA,2) > 1
        fhErrorDim('"iCellStrA"');
    end
end
if size(iCellStrB,2) > 1
    iCellStrB = iCellStrB';
    if size(iCellStrB,2) > 1
        fhErrorDim('"iCellStrB"');
    end
end
pCellStrALength = length(iCellStrA);
pCellStrBLength = length(iCellStrB);
pItemAIndex = repmat(1:pCellStrALength,pCellStrBLength,1);
pItemBIndex = repmat((1:pCellStrBLength)',1,pCellStrALength);
oItemsLocate = [pItemAIndex(:),pItemBIndex(:)];
oItemsCrossPair = [iCellStrA(pItemAIndex(:)),iCellStrB(pItemBIndex(:))];

end
