function [oErrH,oUnrecog,varargout]=GetVarArgins(iArgName,iDefVal,varargin)
error(nargchk(2,Inf,nargin,'struct'));
pOutArgsNo = length(iArgName);
pInVarArgsNo = length(varargin);
varargout = iDefVal;
if mod(pInVarArgsNo,2) ~= 0
    oErrH.Id = 1;
    oErrH.Msg = 'Parameter varargin should be Name/Value pairs.';
    oUnrecog = [];
    return;
end
pInVarArgsName = varargin(1:2:pInVarArgsNo);
oUnrecog = pInVarArgsName;
pInVarArgsVal = varargin(2:2:pInVarArgsNo);
if ~iscellstr(pInVarArgsName)
    oErrH.Id = 2;
    oErrH.Msg = 'Parameter name of varargin must be string.';
    return;
end
pInVarArgsName = cellfun(@(x)lower(x),pInVarArgsName,'UniformOutput',false);
if length(unique(pInVarArgsName)) ~= pInVarArgsNo/2
    oErrH.Id = 3;
    oErrH.Msg = 'Repeated parameter names in varargin.';
    return;
end
if ~iscellstr(iArgName)
    oErrH.Id = 4;
    oErrH.Msg = 'iArgName must be a cell array of strings.';
    return;
end
iArgName = cellfun(@(x)lower(x),iArgName,'UniformOutput',false);
if length(unique(iArgName)) ~= pOutArgsNo
    oErrH.Id = 5;
    oErrH.Msg = 'Repeated parameter names in iArgName.';
    return;
end
[pCk,pLoc] = ismember(pInVarArgsName,iArgName);
varargout(pLoc(pCk)) = pInVarArgsVal(pCk);
if all(pCk)
    oUnrecog = [];
else
    oUnrecog = pInVarArgsName(~pCk);
end
oErrH = [];

end
