function oKM = JzSVMKernel(iU,iV,iKernel,iKernOpti)
error(nargchk(1,4,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
if nargin < 4
    pW = 1;
    pO = 3;
    pB = -1;
else
    pW = f_CheckScalar(iKernOpti.Weight,'Weight');
    pO = f_CheckScalar(iKernOpti.Order,'Order');
    pB = f_CheckScalar(iKernOpti.Bias,'Bias');
end
if nargin < 3
    iKernel = 'gaussian';
end
if nargin < 2 || isempty(iV)
    iV = iU;
end
if size(iU,2) ~= size(iV,2)
    error(pErrId,'iU and iV should have the same number of columns.');
end
iKernel = lower(iKernel);
if pW <= 0
    error(pErrId,['The "Weight" argument of kernal function ' ...
        'should be a positive numeric scalar.']);
end
if pO < 1
    error(pErrId,['The "Order" argument of kernal function ' ...
        'should be a numeric scalar >= 1.']);
end
if pB >= 0
    error(pErrId,['The "Bias" argument for Sigmoid kernal ' ...
        'should be a negative numeric scalar.']);
end
if ~ismember(iKernel,{'htrbf','laplacian'})
    pUVProduct = iU * iV';
end
if ismember(iKernel,{'gaussian','multiquadr','inverquadr','invermq'})
    pUVSqr = repmat(sum(iU.^2,2),1,size(iV,1)) + ...
        repmat(sum(iV'.^2,1),size(iU,1),1) - 2 * pUVProduct;
elseif ~ismember(iKernel,{'htrbf','laplacian','sigmoid','polynomial', ...
        'polyhomo','linear'})
    error(pErrId,'Unrecognized paramter value of kernel function.');
end
switch iKernel
    case 'gaussian'
        oKM = exp(-pW*pUVSqr);
    case 'htrbf'
        pUNo = size(iU,1);
        pVNo = size(iV,1);
        pUOrder = iU.^pO;
        pVOrder = iV.^pO;
        pUVDistance = zeros(pUNo,pVNo);
        for pI1 = 1:pVNo
            pUVDistance(:,pI1) = sum( ...
                abs(pUOrder - repmat(pVOrder(pI1,:),pUNo,1)).^(2/pO), 2);
        end
        oKM = exp(-pW*pUVDistance);
    case 'laplacian'
        pUNo = size(iU,1);
        pVNo = size(iV,1);
        pUVDistance = zeros(pUNo,pVNo);
        for pI1 = 1:pVNo
            pUVDistance(:,pI1) = sum( ...
                abs(iU - repmat(iV(pI1,:),pUNo,1)), 2);
        end
        oKM = exp(-pW*pUVDistance);
    case 'multiquadr'
        oKM = sqrt(1 + pW*pUVSqr);
    case 'inverquadr'
        oKM = 1 ./ (1 + pW*pUVSqr);
    case 'invermq'
        oKM = 1 ./ sqrt(1 + pW*pUVSqr);
    case 'polynomial'
        if pO ~= floor(pO)
            error(pErrId,['The "Order" argument for Polynomial ' ...
                'kernal should be a positive integer.']);
        end
        oKM = (pW*pUVProduct + 1).^pO;
    case 'polyhomo'
        if pO ~= floor(pO)
            error(pErrId,['The "Order" argument for PolyHomo ' ...
                'kernal should be a positive integer.']);
        end
        oKM = pW*(pUVProduct.^pO);
    case 'sigmoid'
        oKM = tanh(pW*pUVProduct + pB);
    case 'linear'
        oKM = pUVProduct;
end

function i_X = f_CheckScalar(i_X,i_XName)
    if ~isnumeric(i_X) || ~isscalar(i_X)
        error(pErrId,['The "',i_XName,'" argument of kernal function ' ...
            'must be a numeric scalar.']);
    end
end

end
