function [oYPredict,oYGroup] = JzSVMPredict(iSVMStruct,iXObserve)
error(nargchk(2,2,nargin,'struct'));
pErrId = ['Matlab:',mfilename];
pSVMStructFieldName = {'SupportVector';'AlphaH';'Bias';'GroupNames'; ...
    'KernelFunction';'KernelFunctionArgs';'ScaleData'};
if ~isstruct(iSVMStruct) || ...
        ~all(ismember(pSVMStructFieldName, fieldnames(iSVMStruct)))
    error(pErrId,'iSVMStruct should be a SVM structure.');
end
if ~isnumeric(iXObserve) || ndims(iXObserve) ~= 2
    error(pErrId,'iXObserve must be a two dimensional numeric matrix.');
end
if size(iXObserve,2) ~= size(iSVMStruct.SupportVector,2)
    error(pErrId,['iXObserve and iSVMStruct.SupportVector should ' ...
        'have the same number of columns.']);
end
if ~isempty(iSVMStruct.ScaleData)
    for pI1 = 1:size(iXObserve, 2)
        iXObserve(:,pI1) = iSVMStruct.ScaleData.ScaleFactor(pI1) * ...
            (iXObserve(:,pI1) + iSVMStruct.ScaleData.Shift(pI1));
    end
end
try
    if ischar(iSVMStruct.KernelFunction)
        pKFMatrix = JzSVMKernel(iSVMStruct.SupportVector, iXObserve, ...
            iSVMStruct.KernelFunction, iSVMStruct.KernelFunctionArgs);
    else
        pKFMatrix = feval(iSVMStruct.KernelFunction, ...
            iSVMStruct.SupportVector, iXObserve);
    end
catch ME
    throw(addCause(MException(pErrId, ...
        'Error in calculating the kernel function matrix.'),ME));
end
if length(iSVMStruct.GroupNames) == 2
    oYPredict = pKFMatrix' * iSVMStruct.AlphaH + iSVMStruct.Bias;
else
    oYPredict = (pKFMatrix' * iSVMStruct.AlphaH) ./ (1 - iSVMStruct.Bias);
end
if nargout == 2
    if iscellstr(iSVMStruct.GroupNames)
        oYGroup = cell(size(oYPredict));
        oYGroup(:) = {''};
        if length(iSVMStruct.GroupNames) == 2
            oYGroup(oYPredict>0) = iSVMStruct.GroupNames(1);
            oYGroup(oYPredict<0) = iSVMStruct.GroupNames(2);
        else
            oYGroup(oYPredict>0.5) = iSVMStruct.GroupNames;
        end
    else
        error(pErrId,['Unrecognized data type of iSVMStruct.GroupNames' ...
            ', should be a cell array of strings.']);
    end
end

end
