from PIL import Image
from VideoCapture import Device
import time
import serial

import cv

filename = r'C:picture.png'
drag_start = None
drag_end = None
box = (0,0,0,0)
subrect = None
histpic = None
rpos = None
pumpspeed = 1.0

thisvol = 0.0
now = 0.0

ser_dir = 'inf'
ser2_dir = 'wdr'

interface = 0.5

def swapover():

    global ser
    global ser2
    global ser_dir
    global ser2_dir

    ser.write('01 stp \x0D')
    ser.write('01 stp \x0D')
    ser.write('01 stp \x0D')
    
    print 'stop1'
    ser2.write('00 stp \x0D')
    ser2.write('00 stp \x0D')
    ser2.write('00 stp \x0D')
    
    print 'stop2'

    if ser_dir == 'wdr':
        print 'a'
        ser.write('01 dir inf \x0D')
        time.sleep(0.5)
        ser_dir = 'inf'
    elif ser_dir == 'inf':
        print 'b'
        
        ser.write('01 dir wdr \x0D')
        time.sleep(0.5)
        ser_dir = 'wdr'

    
    if ser2_dir == 'wdr':
        ser2.write('00 dir inf \x0D')
        time.sleep(0.1)
        ser2_dir = 'inf'
    elif ser2_dir == 'inf':
        ser2.write('00 dir wdr \x0D')
        time.sleep(0.1)
        ser2_dir = 'wdr'
    

    
    

    ser.write('01 run \x0D')
    ser2.write('00 run \x0D')
    return()
    

    return()

def posdo(fract):

    global ser_dir
    global ser2_dir
    global pumpspeed
    global now
    global thisvol
    error = interface - fract
    print  'error = ' + str(error)
    
    newspeed = pumpspeed + (pumpspeed*error*10)
    print 'newspeed = ' + str(newspeed)
    if newspeed > 0.1:
        if newspeed > 900:
            newspeed = 900
        else:
            pass
    else:
        if newspeed <= 0.1:
            newspeed = 0.1
        else:
            pass
    a = round(newspeed, 1)
    b = str(a)
    c = '01 RAT %s \x0D' % b
    d = '00 RAT %s \x0D' % b
    
    ser.write(c)
    ser2.write(d)

    
    print c

    increment = time.clock() - now
    thisvol = thisvol + ((increment/60.0)* a)
    now = time.clock()

    print 'thisvol = ' + str(thisvol)

    if thisvol > 2.0:
        
        swapover()
        time.sleep(0.2)
        thisvol = 0
    else:
        pass
        


def poscalc(refpt1, refpt2, scanpt):

    percent = (float(scanpt[1])-float(refpt2[1]))/(float(refpt1[1])-float(refpt2[1]))
    return percent


def imtocv(f):
    size = f.size
        
    cv_im = cv.CreateImageHeader(f.size, cv.IPL_DEPTH_8U, 3)
    cv.SetData(cv_im, f.tostring())
    
    r = cv.CreateImage(size, 8, 1)
    g = cv.CreateImage(size, 8, 1)
    b = cv.CreateImage(size, 8, 1)
    image = cv.CreateImage(size, 8, 3)
    

    cv.Split(cv_im, r, g, b, None)
    cv.Merge(b,g,r, None, image)
    return image

def thresh(f, firsthue, secondhue):
    size = cv.GetSize(f)
    hsv = cv.CreateImage(size, 8, 3)
    hue = cv.CreateImage(size, 8, 1)
    threshed = cv.CreateImage(size, 8, 1)
    thresh = cv.CreateImage(size, 8, 1)
    cv.CvtColor(f, hsv, cv.CV_BGR2HSV)
    cv.Split(hsv, hue, None, None, None)
    cv.InRangeS(hsv, cv.Scalar(firsthue,40,40), cv.Scalar(secondhue,255,255), threshed)

    cv.Erode(threshed, threshed, iterations = 5)
    cv.Dilate(threshed, threshed, iterations = 5)
    return threshed


def scanthresh(feedpic):
    
    seq = cv.FindContours(feedpic, cv.CreateMemStorage(), cv.CV_RETR_TREE, cv.CV_CHAIN_APPROX_NONE)


    if seq:
        moments = cv.Moments(seq, 1)
        moment10 = cv.GetSpatialMoment(moments, 1, 0)
        moment01 = cv.GetSpatialMoment(moments, 0,1)
        area = cv.GetCentralMoment(moments, 0, 0)
        if area != 0:
            
            posx = moment10/area
            posy = moment01/area

            x = int(posx)
            y = int(posy)

            return (x,y)
        else:
            pass
    else:
        pass

def trackcam(cam, hueval):

    hue1 = hueval-15
    hue2 = hueval+15
    go = True
    while go:

        f = cam.getImage()
        
        image = imtocv(f) #converts to cv format
        

        threshed = thresh(image, hue1, hue2)
        thr = cv.CreateImage(cv.GetSize(threshed), 8, 1)

        
        cv.Copy(threshed, thr)
        
        scanpos = scanthresh(threshed)
        

        if scanpos:
            print scanpos
            cv.Rectangle(image, (scanpos[0],scanpos[1]), (scanpos[0]+10, scanpos[1]+10), (255,255,255))

           

            t = poscalc(refpos1, refpos2, scanpos)
            posdo(t)
            print t

        cv.Circle(image, refpos1, 5, (255,100,100), thickness = 2)
        cv.Circle(image, refpos2, 5, (255,100,100), thickness = 2)
        

        cv.ShowImage('window', image)
        cv.ShowImage('threshed', thr)

        k = cv.WaitKey(7)
        if k == 27:
            del cam
            cv.destroyWindow('window')
            cv.destroyWindow('threshed')
            go = False
            return


def on_mouse(event, x, y, flags, param):
    global drag_start
    global drag_end
    global box
    if event == cv.CV_EVENT_LBUTTONDOWN:
        drag_end = False
        drag_start = (x,y)
        print drag_start
        print 'left down'
    if event == cv.CV_EVENT_LBUTTONUP:
        drag_end = (x,y)
        print drag_end
        print 'left up'
        
    if drag_start and drag_end:
        
        xmin = min (drag_start[0], drag_end[0])
        ymin = min (drag_start[1], drag_end[1])
        xmax = max (drag_start[0], drag_end[0])
        ymax = max (drag_start[1], drag_end[1])
        box = (xmin, ymin, xmax-xmin, ymax-ymin)
    if box:
        print box

def on_mouse2(event, x, y, flags, param):
    global rpos
    if event == cv.CV_EVENT_LBUTTONDOWN:
        rpos = (x,y)
    

def getbox(picfile):
    image = cv.LoadImage(picfile)
    
    cv.NamedWindow('select', 1)
    
    cv.SetMouseCallback('select', on_mouse)

    a = True
    while a:
        
        if box[2]>0 and box[3]>0:
            cv.destroyWindow('select')
            return box
        cv.ShowImage('select', image)
        k = cv.waitKey(7)
        if k ==27:
            cv.destroyWindow('select')
            return None

def gethist(picfile):
    image = cv.LoadImage(picfile)
    size = cv.GetSize(image)
    hsv = cv.CreateImage(size, 8, 3)
    hue = cv.CreateImage(size, 8, 1)
    cv.CvtColor(image, hsv, cv.CV_BGR2HSV)
    cv.Split(hsv, hue, None, None, None)
    hist = cv.CreateHist([180], cv.CV_HIST_ARRAY, [(0,180)], 1)
    cv.SetImageROI(hue, box)
    cv.CalcHist([hue], hist, 0)
    
    
    print 'yes'
    return hist
    
    

def takepic(picfile):
    global box
    cam = Device()
    
    cam.saveSnapshot(picfile)
    del cam

def getrefpos(picfile):
    global rpos
    rpos = None
    image = cv.LoadImage(picfile)
    
    cv.NamedWindow('select refpos', 1)
    
    cv.SetMouseCallback('select refpos', on_mouse2)

    a = True
    while a:
        
        if rpos:
            a = False
            cv.destroyWindow('select refpos')
            return rpos
        cv.ShowImage('select refpos', image)
        k = cv.waitKey(7)
        if k ==27:
            cv.destroyWindow('select refpos')
            return None
    
    
print 'hello'

ser = serial.Serial()
ser.port = 14
ser.baudrate = 19200
ser.open()

ser2 = serial.Serial()
ser2.port = 15
ser2.baudrate = 19200
ser2.open()

ser.write('01 dir inf \x0D')
ser2.write('00 dir wdr \x0D')
ser.write('01 run \x0D')
ser2.write('00 run \x0D')

takepic(filename)

refpos1 = getrefpos(filename)
print refpos1
refpos2 = getrefpos(filename)
print refpos2



mybox = getbox(filename)
b = gethist(filename)


(mn,mx,mnid,mxid) = cv.GetMinMaxHistValue(b)
print mxid

mxid1 = mxid[0]

cam2 = Device()

print 'cam2'

trackcam(cam2, mxid1)





    




    


    
    
    
    
    

